<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeading9, li.MsoHeading9, div.MsoHeading9
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText, li.MsoBodyText, div.MsoBodyText
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:6.0pt;
  margin-left:0in;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyTextIndent, li.MsoBodyTextIndent, div.MsoBodyTextIndent
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:14.2pt;
  margin-bottom:.0001pt;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;}
span.Titre9Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.RetraitcorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.CorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">AINFOSTATFISCFIN</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="89.5%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                           </td>
                           <td width="10.5%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="89.5%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">INFORMATIONS STATISTIQUES, FISCALES ET FINANCIERES</span></b></p>
                              
                           </td>
                           <td width="10.5%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">A</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
                        <tr height="0" class="#tech# #fixWidths#">
                           <td width="82.2%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="17.8%" style="border:none" rowspan="1" colspan="1"/>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="100%" colspan="2" valign="top" style="border:double black 2.25pt; border-bottom:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Informations statistiques</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="82.2%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1"> </td>
                           <td width="17.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Valeurs</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="82.2%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Population totale</span></p>
                              
                           </td>
                           <td width="17.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='PopTot')]/@V)"/></span></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab3">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr height="0" class="#tech# #fixWidths#">
                           <td width="82.1%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="17.9%" style="border:none" rowspan="1" colspan="1"/>
                        </tr>
                        <tr style="page-break-inside:avoid;height:12.6pt">
                           <td width="100%" colspan="2" style="border:double black 2.25pt; border-bottom:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:12.6pt" rowspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Informations fiscales (N-2)</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid;height:12.6pt">
                           <td width="82.1%" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:12.6pt" rowspan="1" colspan="1"> </td>
                           <td width="17.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:12.6pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Collectivité</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid;height:7.75pt">
                           <td width="82.1%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:7.75pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Indicateur de ressources fiscales ou potentiel fiscal par habitant (1)</span></p>
                              
                           </td>
                           <td width="17.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:7.75pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='PotFisc')]/@V)"/></span></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab3"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab4">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr height="0" class="#tech# #fixWidths#">
                           <td width="4%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="77.9%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="18.1%" style="border:none" rowspan="1" colspan="1"/>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="81.9%" colspan="2" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              <p class="MsoHeading9"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Ratios de niveau</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Valeurs</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">1</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Dépenses réelles de fonctionnement / population</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValDepRFonc')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">2</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Recettes réelles de fonctionnement / population</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValRecRFonc')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">3</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Dépenses d’équipement brut / population</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValDepEq')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">4</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Encours de dette / population (2)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValEncDettePop')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">5</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">DGF / population</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValDGFPop')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="81.9%" colspan="2" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              <p class="MsoHeading9"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Ratios de structure et d’analyse financière</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Valeurs</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">6</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Dépenses de personnel / dépenses réelles de fonctionnement (3)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValDepPers')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">7</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Dépenses réelles de fonctionnement et remboursement annuel de la dette en capital / recettes réelles de fonctionnement (3)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValDepFoncRemDette')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">8</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Taux d’épargne brute (Epargne brute / recettes réelles de fonctionnement) (2) (3)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValEparRFonc')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">9</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Taux d’épargne nette ( (Epargne brute – remboursement annuel de la dette en capital) / recettes réelles de fonctionnement)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValEparNetRFonc')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">10</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Ratio d’endettement (Encours de la dette / recettes réelles de fonctionnement) (2) (3)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValEncDetteRecFonc')]/@V)"/></span></p>
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid">
                           <td width="4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">11</span></p>
                              
                           </td>
                           <td width="77.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Capacité de désendettement (encours de dette / épargne brute) (2) (3)</span></p>
                              
                           </td>
                           <td width="18.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='ValEncDetteEpar')]/@V)"/></span></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab4"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) A renseigner selon les dispositions législatives et réglementaires applicables à la collectivité. Informations comprises
                     dans la fiche de répartition de la DGF de l’exercice N-1, établie sur la base des informations N-2 (transmise par les services
                     préfectoraux).</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) Les ratios s’appuyant sur l’encours de la dette se calculent à partir du montant de la dette au 1<sup>er</sup> janvier N.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) Pour les syndicats mixtes, seules ces données sont à renseigner.</span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>